<?php
function my_theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

function manage_recaptcha_on_nous_rejoindre() {
    // Supprime globalement les scripts reCAPTCHA
    wp_dequeue_script('google-recaptcha');
    wp_dequeue_script('wpcf7-recaptcha');

    // Active reCAPTCHA uniquement sur la page "ticketing"
    if (is_page('nous-rejoindre')) { // Vérifie si la page actuelle est "ticketing"
        if (function_exists('wpcf7_recaptcha_enqueue_scripts')) {
            wpcf7_recaptcha_enqueue_scripts(); // Charge les scripts nécessaires pour reCAPTCHA
        }
        wp_enqueue_script('google-recaptcha', 'https://www.google.com/recaptcha/api.js', array(), null, true);
    }
}
add_action('wp_enqueue_scripts', 'manage_recaptcha_on_nous_rejoindre', 20);
