import React from 'react';
import {__} from '@wordpress/i18n';

const RightMenu = ({pro_link}) => {
    return (
        <div className="right-menu flex items-center">
            {pro_link ? (
                <a
                    href={pro_link}
                    className="mx-2 text-sm font-medium text-de-app-color-dark flex items-center gap-1 hover:text-de-app-color"
                >
                    <svg width="20" height="13" viewBox="0 0 20 13" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M18.71 4.34004C18.21 3.91004 17.52 3.79004 16.91 4.03004L14.24 5.10004L11.37 1.51004C10.7 0.670045 9.3 0.680045 8.64 1.51004L5.77 5.10004L3.1 4.03004C2.49 3.78004 1.8 3.90004 1.3 4.34004C0.799996 4.77004 0.589996 5.44004 0.749996 6.08004L2.09 11.42C2.29 12.2 2.98 12.75 3.79 12.75H16.23C17.03 12.75 17.73 12.21 17.93 11.42L19.27 6.08004C19.43 5.44004 19.22 4.77004 18.72 4.34004H18.71ZM16.46 11.06C16.43 11.17 16.33 11.25 16.22 11.25H3.78C3.66 11.25 3.57 11.17 3.54 11.06L2.2 5.72004C2.17 5.59004 2.24 5.51004 2.28 5.47004C2.31 5.44004 2.37 5.41004 2.44 5.41004C2.47 5.41004 2.5 5.41004 2.54 5.43004L5.72 6.70004C6.03 6.82004 6.38 6.73004 6.58 6.47004L9.8 2.45004C9.93 2.29004 10.06 2.29004 10.19 2.45004L13.41 6.47004C13.62 6.73004 13.97 6.82004 14.27 6.70004L17.45 5.43004C17.57 5.38004 17.66 5.43004 17.71 5.47004C17.75 5.51004 17.82 5.59004 17.79 5.72004L16.45 11.06H16.46Z"
                            fill="#0E40FF"
                        />
                    </svg>

                    {__('Upgrade Now', 'addons-for-divi')}
                </a>
            ) : null}

            <a
                href="https://diviepic.com/docs"
                target="_blank"
                rel="noopener noreferrer"
                role="button"
                className="mx-2 text-sm font-medium text-de-black flex items-center gap-1 hover:text-de-app-color"
            >
                <svg className="w-5 h-5" focusable="false" viewBox="0 0 24 24">
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M12 3.75C7.44365 3.75 3.75 7.44365 3.75 12C3.75 16.5563 7.44365 20.25 12 20.25C16.5563 20.25 20.25 16.5563 20.25 12C20.25 7.44365 16.5563 3.75 12 3.75ZM2.25 12C2.25 6.61522 6.61522 2.25 12 2.25C17.3848 2.25 21.75 6.61522 21.75 12C21.75 17.3848 17.3848 21.75 12 21.75C6.61522 21.75 2.25 17.3848 2.25 12ZM11.4346 6.31004C12.1055 6.17314 12.8016 6.27204 13.4089 6.58932L13.4116 6.59074C14.0173 6.91037 14.4974 7.42629 14.7778 8.05316C15.0582 8.6798 15.1241 9.38318 14.9657 10.0516C14.8073 10.7201 14.4329 11.3179 13.8992 11.7478C13.5634 12.0182 13.1769 12.2121 12.766 12.3194L12.766 13C12.766 13.4142 12.4302 13.75 12.016 13.75C11.6018 13.75 11.266 13.4142 11.266 13L11.266 11.6666C11.266 11.2533 11.6003 10.9179 12.0136 10.9166C12.3547 10.9155 12.6874 10.7978 12.9583 10.5796C13.2296 10.3611 13.4236 10.054 13.5061 9.7057C13.5887 9.35728 13.5541 8.99081 13.4087 8.66579C13.2635 8.34144 13.0175 8.07918 12.7129 7.91806C12.4103 7.76042 12.0658 7.71214 11.7345 7.77976C11.4024 7.84752 11.0997 8.02843 10.8772 8.29658C10.6126 8.61532 10.1398 8.65925 9.82106 8.39471C9.50232 8.13018 9.45839 7.65734 9.72293 7.3386C10.1611 6.81066 10.7638 6.44691 11.4346 6.31004ZM12 15.25C12.4142 15.25 12.75 15.5858 12.75 16V16.04C12.75 16.4542 12.4142 16.79 12 16.79C11.5858 16.79 11.25 16.4542 11.25 16.04V16C11.25 15.5858 11.5858 15.25 12 15.25Z"
                    ></path>
                </svg>
                {__('Knowledge Base', 'addons-for-divi')}
            </a>
        </div>
    );
};

export default RightMenu;
