<?php
/*
Plugin Name: SEO Open Graph
Plugin URI: https://github.com/flavienkreidi/wordpress-seo-open-graph
GitHub Plugin URI: https://github.com/flavienkreidi/wordpress-seo-open-graph
Description: Cette extension permet une optimisation SEO en ajoutant automatiquement les meta Opengraph et Twitter Cards aux posts.
Author: Flavien KREIDI
Author URI: https://flavienkreidi.design
Version: 2.5.1
*/

if (!defined('ABSPATH')) exit;

/*TWITTER CARDS*/
add_action('wp_head', 'add_twitter_cards');
function add_twitter_cards() {
    if(is_single()) {
      $tc_url = get_permalink();
      $tc_site = get_home_url();
      $tc_title = get_the_title();
      $tc_description = get_the_excerpt();
      $tc_image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );
      $tc_image_thumb = $tc_image[0];
      $tc_author = str_replace('@', '', get_the_author_meta('twitter'));
?>
    <meta name="twitter:card" value="summary" />
    <meta name="twitter:site" value="<?php echo $tc_site; ?>" />
    <meta name="twitter:title" value="<?php echo $tc_title; ?>" />
    <meta name="twitter:description" value="<?php echo $tc_description; ?>" />
    <meta name="twitter:url" value="<?php echo $tc_url; ?>" />
      <?php if($tc_image) { ?>
      <meta name="twitter:image" value="<?php echo $tc_image_thumb; ?>" />
        <?php } if($tc_author) { ?>
        <meta name="twitter:creator" value="@<?php echo $tc_author; ?>" />
<?php
    }
  }
}
/*OPEN GRAPH*/
function doctype_opengraph($output) {
    return $output . '
    xmlns:og="http://opengraphprotocol.org/schema/"
    xmlns:fb="http://www.facebook.com/2008/fbml"';
}
add_filter('language_attributes', 'doctype_opengraph');

function fb_opengraph() {
    global $post;

    if(is_single()) {
        if(has_post_thumbnail($post->ID)) {
            $img_src = wp_get_attachment_image_src(get_post_thumbnail_id( $post->ID ), 'medium_large');
        } else {
            /*$img_src = get_stylesheet_directory_uri() . '/DEFAULT IMG URL HERE';*/
            $img_src = '#';
        }
        if($excerpt = $post->post_excerpt) {
            $excerpt = strip_tags($post->post_excerpt);
            $excerpt = str_replace("", "'", $excerpt);
        } else {
            $excerpt = get_bloginfo('description');
        }
        ?>

    <meta property="og:title" content="<?php echo the_title(); ?>"/>
    <meta property="og:description" content="<?php echo $excerpt; ?>"/>
    <meta property="og:type" content="article"/>
    <meta property="og:url" content="<?php echo the_permalink(); ?>"/>
    <meta property="og:site_name" content="<?php echo get_bloginfo(); ?>"/>
    <meta property="og:image" content="<?php echo $img_src[0]; ?>"/>

<?php
    } else {
        return;
    }
}
add_action('wp_head', 'fb_opengraph', 5);
